<?php
// public/js/index.php

header('Content-Type: application/javascript');
?>

function callNext(departmentId, counterName) {
    fetch('/src/actions/call_next.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ department_id: departmentId, counter_name: counterName }),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Next:', data);
        // Atualizar display de senhas
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function repeatCurrent(departmentId) {
    fetch('/src/actions/repeat_current.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ department_id: departmentId }),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Current:', data);
        // Atualizar display de senhas
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function callSpecific(departmentId, number, counterName) {
    fetch('/src/actions/call_specific.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ department_id: departmentId, number: number, counter_name: counterName }),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Specific:', data);
        // Atualizar display de senhas
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function updateDisplay() {
    fetch('/src/actions/get_display_data.php')
    .then(response => response.json())
    .then(data => {
        // Atualizar display de senhas
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

setInterval(updateDisplay, 5000);
