<?php
// src/controllers/DepartmentController.php

require_once '../config/database.php';
require_once '../models/Department.php';

class DepartmentController {
    public static function create($data) {
        $department = new Department();
        $department->name = $data['name'];
        $department->priority = isset($data['priority']) ? 1 : 0;
        $department->code = $data['code'];
        $department->shortcut_key = $data['shortcut_key'];
        $department->counter_name = $data['counter_name'];
        $department->save();
    }

    public static function update($id, $data) {
        $department = Department::find($id);
        if ($department) {
            $department->name = $data['name'];
            $department->priority = isset($data['priority']) ? 1 : 0;
            $department->code = $data['code'];
            $department->shortcut_key = $data['shortcut_key'];
            $department->counter_name = $data['counter_name'];
            $department->save();
        }
    }

    public static function delete($id) {
        $department = Department::find($id);
        if ($department) {
            $department->delete();
        }
    }

    public static function list() {
        return Department::all();
    }
}
?>
