<?php
// src/controllers/RemoteController.php

require_once '../config/database.php';
require_once '../models/Queue.php';
require_once '../models/Department.php';

class RemoteController {
    public static function callNext($department_id, $counter_name) {
        $queue = Queue::nextInLine($department_id);
        if ($queue) {
            $queue->called_at = date('Y-m-d H:i:s');
            $queue->counter_name = $counter_name;
            $queue->save();
            return $queue;
        }
        return null;
    }

    public static function repeatCurrent($department_id) {
        $queue = Queue::currentInLine($department_id);
        return $queue;
    }

    public static function callSpecific($department_id, $number, $counter_name) {
        $queue = Queue::findByNumber($department_id, $number);
        if ($queue) {
            $queue->called_at = date('Y-m-d H:i:s');
            $queue->counter_name = $counter_name;
            $queue->save();
            return $queue;
        }
        return null;
    }
}
?>
