<?php
// src/controllers/UserController.php

require_once '../config/database.php';
require_once '../models/User.php';

class UserController {
    public static function create($data) {
        $user = new User();
        $user->name = $data['name'];
        $user->password = password_hash($data['password'], PASSWORD_DEFAULT);
        $user->is_admin = isset($data['is_admin']) ? 1 : 0;
        $user->save();

        foreach ($data['departments'] as $department_id) {
            $user->assignDepartment($department_id);
        }
    }

    public static function update($id, $data) {
        $user = User::find($id);
        if ($user) {
            $user->name = $data['name'];
            if (!empty($data['password'])) {
                $user->password = password_hash($data['password'], PASSWORD_DEFAULT);
            }
            $user->is_admin = isset($data['is_admin']) ? 1 : 0;
            $user->save();

            $user->clearDepartments();
            foreach ($data['departments'] as $department_id) {
                $user->assignDepartment($department_id);
            }
        }
    }

    public static function delete($id) {
        $user = User::find($id);
        if ($user) {
            $user->delete();
        }
    }

    public static function list() {
        return User::all();
    }
}
?>
