<?php
// src/models/Department.php

require_once '../config/database.php';

class Department {
    public $id;
    public $name;
    public $priority;
    public $code;
    public $shortcut_key;
    public $counter_name;

    public function save() {
        global $pdo;
        if ($this->id) {
            $stmt = $pdo->prepare("UPDATE departments SET name = ?, priority = ?, code = ?, shortcut_key = ?, counter_name = ? WHERE id = ?");
            $stmt->execute([$this->name, $this->priority, $this->code, $this->shortcut_key, $this->counter_name, $this->id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO departments (name, priority, code, shortcut_key, counter_name) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$this->name, $this->priority, $this->code, $this->shortcut_key, $this->counter_name]);
            $this->id = $pdo->lastInsertId();
        }
    }

    public function delete() {
        global $pdo;
        $stmt = $pdo->prepare("DELETE FROM departments WHERE id = ?");
        $stmt->execute([$this->id]);
    }

    public static function find($id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM departments WHERE id = ?");
        $stmt->execute([$id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $department = new Department();
            $department->id = $data['id'];
            $department->name = $data['name'];
            $department->priority = $data['priority'];
            $department->code = $data['code'];
            $department->shortcut_key = $data['shortcut_key'];
            $department->counter_name = $data['counter_name'];
            return $department;
        }
        return null;
    }

    public static function all() {
        global $pdo;
        $stmt = $pdo->query("SELECT * FROM departments");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
