<?php
// src/models/Display.php

require_once '../config/database.php';

class Display {
    public $id;
    public $name;
    public $departments;
    public $message;

    public function save() {
        global $pdo;
        if ($this->id) {
            $stmt = $pdo->prepare("UPDATE displays SET name = ?, departments = ?, message = ? WHERE id = ?");
            $stmt->execute([$this->name, $this->departments, $this->message, $this->id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO displays (name, departments, message) VALUES (?, ?, ?)");
            $stmt->execute([$this->name, $this->departments, $this->message]);
            $this->id = $pdo->lastInsertId();
        }
    }

    public function delete() {
        global $pdo;
        $stmt = $pdo->prepare("DELETE FROM displays WHERE id = ?");
        $stmt->execute([$this->id]);
    }

    public static function find($id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM displays WHERE id = ?");
        $stmt->execute([$id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $display = new Display();
            $display->id = $data['id'];
            $display->name = $data['name'];
            $display->departments = $data['departments'];
            $display->message = $data['message'];
            return $display;
        }
        return null;
    }

    public static function all() {
        global $pdo;
        $stmt = $pdo->query("SELECT * FROM displays");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
