<?php
// src/models/Kiosk.php

require_once '../config/database.php';

class Kiosk {
    public $id;
    public $name;
    public $departments;
    public $message;

    public function save() {
        global $pdo;
        if ($this->id) {
            $stmt = $pdo->prepare("UPDATE kiosks SET name = ?, departments = ?, message = ? WHERE id = ?");
            $stmt->execute([$this->name, $this->departments, $this->message, $this->id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO kiosks (name, departments, message) VALUES (?, ?, ?)");
            $stmt->execute([$this->name, $this->departments, $this->message]);
            $this->id = $pdo->lastInsertId();
        }
    }

    public function delete() {
        global $pdo;
        $stmt = $pdo->prepare("DELETE FROM kiosks WHERE id = ?");
        $stmt->execute([$this->id]);
    }

    public static function find($id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM kiosks WHERE id = ?");
        $stmt->execute([$id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $kiosk = new Kiosk();
            $kiosk->id = $data['id'];
            $kiosk->name = $data['name'];
            $kiosk->departments = $data['departments'];
            $kiosk->message = $data['message'];
            return $kiosk;
        }
        return null;
    }

    public static function all() {
        global $pdo;
        $stmt = $pdo->query("SELECT * FROM kiosks");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
