<?php
// src/models/Queue.php

require_once '../config/database.php';

class Queue {
    public $id;
    public $department_id;
    public $number;
    public $called_at;
    public $counter_name;

    public function save() {
        global $pdo;
        if ($this->id) {
            $stmt = $pdo->prepare("UPDATE queues SET department_id = ?, number = ?, called_at = ?, counter_name = ? WHERE id = ?");
            $stmt->execute([$this->department_id, $this->number, $this->called_at, $this->counter_name, $this->id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO queues (department_id, number, called_at, counter_name) VALUES (?, ?, ?, ?)");
            $stmt->execute([$this->department_id, $this->number, $this->called_at, $this->counter_name]);
            $this->id = $pdo->lastInsertId();
        }
    }

    public static function nextInLine($department_id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM queues WHERE department_id = ? AND called_at IS NULL ORDER BY id ASC LIMIT 1");
        $stmt->execute([$department_id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $queue = new Queue();
            $queue->id = $data['id'];
            $queue->department_id = $data['department_id'];
            $queue->number = $data['number'];
            $queue->called_at = $data['called_at'];
            $queue->counter_name = $data['counter_name'];
            return $queue;
        }
        return null;
    }

    public static function currentInLine($department_id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM queues WHERE department_id = ? AND called_at IS NOT NULL ORDER BY called_at DESC LIMIT 1");
        $stmt->execute([$department_id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $queue = new Queue();
            $queue->id = $data['id'];
            $queue->department_id = $data['department_id'];
            $queue->number = $data['number'];
            $queue->called_at = $data['called_at'];
            $queue->counter_name = $data['counter_name'];
            return $queue;
        }
        return null;
    }

    public static function findByNumber($department_id, $number) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM queues WHERE department_id = ? AND number = ?");
        $stmt->execute([$department_id, $number]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $queue = new Queue();
            $queue->id = $data['id'];
            $queue->department_id = $data['department_id'];
            $queue->number = $data['number'];
            $queue->called_at = $data['called_at'];
            $queue->counter_name = $data['counter_name'];
            return $queue;
        }
        return null;
    }
}
?>
