<?php
// src/models/User.php

require_once '../config/database.php';

class User {
    public $id;
    public $name;
    public $password;
    public $is_admin;

    public function save() {
        global $pdo;
        if ($this->id) {
            $stmt = $pdo->prepare("UPDATE users SET name = ?, password = ?, is_admin = ? WHERE id = ?");
            $stmt->execute([$this->name, $this->password, $this->is_admin, $this->id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO users (name, password, is_admin) VALUES (?, ?, ?)");
            $stmt->execute([$this->name, $this->password, $this->is_admin]);
            $this->id = $pdo->lastInsertId();
        }
    }

    public function delete() {
        global $pdo;
        $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
        $stmt->execute([$this->id]);
    }

    public static function find($id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $user = new User();
            $user->id = $data['id'];
            $user->name = $data['name'];
            $user->password = $data['password'];
            $user->is_admin = $data['is_admin'];
            return $user;
        }
        return null;
    }

    public static function all() {
        global $pdo;
        $stmt = $pdo->query("SELECT * FROM users");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function assignDepartment($department_id) {
        global $pdo;
        $stmt = $pdo->prepare("INSERT INTO user_departments (user_id, department_id) VALUES (?, ?)");
        $stmt->execute([$this->id, $department_id]);
    }

    public function clearDepartments() {
        global $pdo;
        $stmt = $pdo->prepare("DELETE FROM user_departments WHERE user_id = ?");
        $stmt->execute([$this->id]);
    }
}
?>
