<!-- src/views/department/list.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Lista de Departamentos</title>
</head>
<body>
    <h1>Lista de Departamentos</h1>
    <a href="create.php">Cadastrar Novo Departamento</a>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Prioritário</th>
                <th>Sigla</th>
                <th>Tecla de Atalho</th>
                <th>Guichê</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php
            require_once '../../controllers/DepartmentController.php';
            $departments = DepartmentController::list();
            foreach ($departments as $department) {
                echo "<tr>";
                echo "<td>{$department['id']}</td>";
                echo "<td>{$department['name']}</td>";
                echo "<td>" . ($department['priority'] ? 'Sim' : 'Não') . "</td>";
                echo "<td>{$department['code']}</td>";
                echo "<td>{$department['shortcut_key']}</td>";
                echo "<td>{$department['counter_name']}</td>";
                echo "<td>
                        <a href='edit.php?id={$department['id']}'>Editar</a> | 
                        <a href='../../actions/delete_department.php?id={$department['id']}'>Excluir</a>
                      </td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
</body>
</html>
