<!-- src/views/user/create.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Usuário</title>
</head>
<body>
    <h1>Cadastrar Usuário</h1>
    <form action="../../actions/create_user.php" method="post">
        <label for="name">Nome:</label>
        <input type="text" name="name" id="name" required>
        <br>
        <label for="password">Senha:</label>
        <input type="password" name="password" id="password" required>
        <br>
        <label for="is_admin">Administrador:</label>
        <input type="checkbox" name="is_admin" id="is_admin">
        <br>
        <label for="departments">Departamentos:</label>
        <select name="departments[]" id="departments" multiple required>
            <?php
            require_once '../../controllers/DepartmentController.php';
            $departments = DepartmentController::list();
            foreach ($departments as $department) {
                echo "<option value='{$department['id']}'>{$department['name']}</option>";
            }
            ?>
        </select>
        <br>
        <button type="submit">Cadastrar</button>
    </form>
    <a href="list.php">Voltar para a lista</a>
</body>
</html>
