<!-- src/views/user/edit.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Editar Usuário</title>
</head>
<body>
    <h1>Editar Usuário</h1>
    <?php
    require_once '../../controllers/UserController.php';
    require_once '../../controllers/DepartmentController.php';
    $user = UserController::find($_GET['id']);
    $user_departments = array_map(function($d) { return $d['department_id']; }, $user->departments());
    if ($user):
    ?>
    <form action="../../actions/edit_user.php?id=<?php echo $user['id']; ?>" method="post">
        <label for="name">Nome:</label>
        <input type="text" name="name" id="name" value="<?php echo $user['name']; ?>" required>
        <br>
        <label for="password">Senha:</label>
        <input type="password" name="password" id="password">
        <br>
        <label for="is_admin">Administrador:</label>
        <input type="checkbox" name="is_admin" id="is_admin" <?php echo $user['is_admin'] ? 'checked' : ''; ?>>
        <br>
        <label for="departments">Departamentos:</label>
        <select name="departments[]" id="departments" multiple required>
            <?php
            $departments = DepartmentController::list();
            foreach ($departments as $department) {
                $selected = in_array($department['id'], $user_departments) ? 'selected' : '';
                echo "<option value='{$department['id']}' $selected>{$department['name']}</option>";
            }
            ?>
        </select>
        <br>
        <button type="submit">Salvar</button>
    </form>
    <a href="list.php">Voltar para a lista</a>
    <?php else: ?>
        <p>Usuário não encontrado.</p>
        <a href="list.php">Voltar para a lista</a>
    <?php endif; ?>
</body>
</html>
