<!-- src/views/user/list.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Lista de Usuários</title>
</head>
<body>
    <h1>Lista de Usuários</h1>
    <a href="create.php">Cadastrar Novo Usuário</a>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Administrador</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php
            require_once '../../controllers/UserController.php';
            $users = UserController::list();
            foreach ($users as $user) {
                echo "<tr>";
                echo "<td>{$user['id']}</td>";
                echo "<td>{$user['name']}</td>";
                echo "<td>" . ($user['is_admin'] ? 'Sim' : 'Não') . "</td>";
                echo "<td>
                        <a href='edit.php?id={$user['id']}'>Editar</a> | 
                        <a href='../../actions/delete_user.php?id={$user['id']}'>Excluir</a>
                      </td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
</body>
</html>
